rm()
rm(list = ls())

require(orthopolynom) #orthogonal polynomial package
require(parallel)
require("quadprog")   #quadratic programming package for estimation

require(nleqslv)
library(R.matlab)
library("foreach")
library("doParallel")
library("ragtop")
library("doSNOW")

setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

source(file = file.path(dirname(getwd()), "functions", "kfold.R"))            #for cross validation
source(file = file.path(dirname(getwd()), "functions", "CVJ.R"))              #cross validation to choose truncation order
source(file = file.path(dirname(getwd()), "functions",  "RND.r"))             #calculate the RND based on the European option price
source(file = file.path(dirname(getwd()), "functions",  "eep_hst.r"))         #compute the early exercise premium (eep) for a given exercise boundary and transition density  
source(file = file.path(dirname(getwd()), "functions", "hst_eo_app.r"))       #compute the European option price
source(file = file.path(dirname(getwd()), "functions", "EEPC.R")) 
source(file = file.path(dirname(getwd()), "functions", "GBM_EO_AO.r")) 
source(file = file.path(dirname(getwd()), "functions", "comparison_mse_functions.r")) 
source(file = file.path(dirname(getwd()), "functions", "sievebound.R")) 


####################################################################################################################
### choose expiry###
t<-365/365#0.0833


ObsErr <- 0.1# add 10% error
bd<-10 # error bound

# sim num
nsim <- 5000
negtol=-0.001
#####################################################################################

n.cores <- 48

my.cluster <- parallel::makeCluster(
  n.cores#, 
  #type = "PSOCK"
)


doParallel::registerDoParallel(cl = my.cluster)
registerDoSNOW(my.cluster)
iterations<-5000
pb<-txtProgressBar(max=iterations,style=3)
progress<-function(n) setTxtProgressBar(pb,n)
opts<-list(progress=progress)


tfsv<-readMat(file.path(dirname(getwd()), "data",'sv2_spd1y1.mat'))
den<-readMat(file.path(dirname(getwd()), "data",'sv2_den1y1.mat'))



S0  = tfsv$S0[1,1];  #Initial price
r    = .05;  #Interest rate
delta    = 0;  #dividend yield############################################################################
#t    = 180/365;    #Time (in years)
sigma = 0.35;  # implied vol, not needed, placeholder
M<-10
Delta<-t/M
#K<-seq(150,1650,10)

K1 = seq(100,200,10)#100:10:200;
K2 = seq(200,250,5)#200:5:250;
K3 = seq(250,280,2)#250:2:280;
K4 = seq(280,320,1)#280:1:320;
K5 = seq(320,350,2)#320:2:350;
K6 = seq(350,400,5)#350:5:400;
K7 = seq(400,500,10)#400:10:500;
Kvec=c(K1,K2,K3,K4,K5,K6,K7)+200
K0=unique(Kvec);

#Kvec=150:10:1650;

#K<-seq(150,1650,10)


ncall<-length(K0)
tol<-0.1 #for finding the EEP
ptol<-0.05*sqrt(t)

#bd<-10  #max 10 dollars

xlim_right<-100
xlim_left<-900



AO_P<-tfsv$prices.put
AO_C<-tfsv$prices.call
EO_P<-tfsv$prices.eo.put
EO_C<-tfsv$prices.eo.call
EEP_P<-AO_P-EO_P
EEP_C<-AO_C-EO_C


x1=(den$xi[1,]-S0)/S0  #the true density
y1=den$f[1,]*S0
xmse<-seq(min(x1),max(x1),by=0.01) #MSEs are computed at these points
##################################################################################################
#######################   Recover SPD based on the European option price  ######################################
###############################################################################################




##update implied vol

call<-cbind(rep(20000101,length(K0)),rep(t*365,length(K0)),rep(1,length(K0)),K0,EO_C,rep(S0,length(K0)),rep(67.8,length(K0)),rep((r)/365,length(K0)),rep(sigma,length(K0)))
put<-cbind(rep(20000101,length(K0)),rep(t*365,length(K0)),rep(0,length(K0)),K0,EO_P,rep(S0,length(K0)),rep(67.8,length(K0)),rep((r)/365,length(K0)),rep(sigma,length(K0)))
OptionTau<-data.frame(rbind(call,put))
colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")



date<-20000101
rnd0<-RND(OptionTau,date)
x<-rnd0[[1]]
beta<-rnd0[[2]]
Ts<-rnd0[[3]]
ST0  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))

#RND_ST0 <- t(Ts) %*% beta / (sigma*sqrt(t)*ST0)
RND_ST0 <- t(Ts) %*% beta / (sigma*sqrt(t)*ST0)



RR0 <- (ST0-S0)/S0
RND_R0 <- RND_ST0*S0


########################   initial step for Modified Melick-Thomas method     #####################
call<-cbind(rep(20000101,length(K0)),rep(t*365,length(K0)),rep(1,length(K0)),K0,AO_C,rep(S0,length(K0)),rep(67.8,length(K0)),rep((r)/365,length(K0)),rep(sigma,length(K0)))
put<-cbind(rep(20000101,length(K0)),rep(t*365,length(K0)),rep(0,length(K0)),K0,AO_P,rep(S0,length(K0)),rep(67.8,length(K0)),rep((r)/365,length(K0)),rep(sigma,length(K0)))
OptionTau<-data.frame(rbind(call,put))
colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")

OptionDateTau <- OptionTau
rf <- OptionDateTau[1,8]
st <- OptionDateTau[1,6] # spot price
tau <- OptionDateTau[1,2]


pos <- which( min(abs(OptionDateTau[,4] - st)) == abs(OptionDateTau[,4] - st)  )
ImpVol <- mean(OptionDateTau[pos,9])
Sigma <-  1*ImpVol*sqrt(1/365)


# Call option 
pos <- which(OptionDateTau[,3] %in% 1)
CallOption <- OptionDateTau[pos,]
CallOption<-CallOption[order(CallOption[,4]),]

Kcall <- CallOption[,4]
Pcall <- CallOption[,5]
ncall <- length(Pcall)



# sort the call price
tempTrash <- sort(Kcall,index.return=T)
Kcall <- tempTrash$x
Pcall <- Pcall[tempTrash$ix]
rm(tempTrash)

# Put option 
pos <- which(OptionDateTau[,3] %in% 0)
PutOption <- OptionDateTau[pos,]
PutOption<-PutOption[order(PutOption[,4]),]

Kput <- PutOption[,4]                   
Pput <- PutOption[,5]

# sort the put price
tempTrash <- sort(Kput,index.return=T)
Kput <- tempTrash$x
Pput <- Pput[tempTrash$ix]
rm(tempTrash)

K <- append(Kcall, Kput)
P <- append(Pcall, Pput)

n <- length(K)
k <- (log(K/st) - rf*tau) / (Sigma*sqrt(tau))

rnd0<-RND(OptionTau,20000101)
beta0<-rnd0[[2]]
degree<-length(beta0)-1

# number of grid points for computing integrals
m <- 2000    

# axis range for integration: 
minR <- -10
maxR <- 10

# x-axis on which hermite polys take values
x <- seq( minR, maxR, length.out=m)

# axis range for returns, for display purposes only
axisL2 = -0.6
axisR2 = 0.6

phi <- exp(-x^2 / 2)

# poly.list indicates which polynomials to use
poly.list <- hermite.h.polynomials( degree, normalized=F )    

# Tx is the matrix of basis functions 
# Ts is the orthonormal basis
Tx <- do.call(rbind, polynomial.values(poly.list, x))
Ts0 <- sweep(Tx, MARGIN=2, phi, '*')
for(i in 0:degree)
{
  Ts0[i+1,] = (2^i * factorial(i) * sqrt(pi))^(-0.5) * Ts0[i+1,]
}

# Compute the regressors for the linear regression

htemp <- x[2:length(x)]-x[1:(length(x)-1)]
ci <- 0.5*htemp[1:(length(htemp)-1)] + 0.5*htemp[2:length(htemp)]
ci <- c(htemp[1], ci, htemp[length(htemp)])
m <- length(ci)
rm(htemp)

# ci matrix
Ci <- matrix(rep(ci, n), nrow=n, byrow=TRUE)

# g is matrix of payoff
#g1: E[max[0,f-X]] for C^u and E[max[0,X-f]] for P^u in Melick and Thomas 
g1 <- matrix(rep(1, n*m),  nrow=n, byrow=TRUE)  


for (i in 1:n ) 
{
  if (i <= ncall) {
    temp <- st * ( exp(sqrt(tau)*Sigma*x) - 
                     exp(sqrt(tau)*Sigma*k[i]) )
  }
  else if (i > ncall) {
    temp <- st * ( exp(sqrt(tau)*Sigma*k[i]) - 
                     exp(sqrt(tau)*Sigma*x) )
  }
  temp[temp<0] = 0
  g1[i,] <- temp
  rm(temp)
}

#g2: E[0,f-X] in C^l and E[0,X-f] in P^l in Melick and Thomas 
g2 <- matrix(rep(1, n*m),  nrow=n, byrow=TRUE)  


for (i in 1:n ) 
{
  if (i <= ncall) {
    temp <- st * ( exp(sqrt(tau)*Sigma*x)  )-K[i]
  }
  else if (i > ncall) {
    temp <- K[i]+ st * (  - exp(sqrt(tau)*Sigma*x) )
  }
  
  g2[i,] <- temp
  rm(temp)
}

G1<-g1*Ci
G2<-g2*Ci
R1 = G1 %*% t(Ts0)
R2 = G2 %*% t(Ts0)

v1<-c(rep(0,length(beta0)),1,0)
v2<-c(rep(0,length(beta0)),0,1)
v3<-c(rep(0,length(beta0)),-1,0)
v4<-c(rep(0,length(beta0)),0,-1)

opt<-constrOptim(c(beta0,1/2,1/2),sievebound_mse,NULL,ui=rbind(t(rbind(Ts0,rep(0,m),rep(0,m))),v1,v2,v3,v4),ci=c(rep(negtol,m),0,0,-1,-1))


price<-sievebound_price(opt$par)
beta<-opt$par[1:(degree+1)]
ST0  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))
RND_ST0 <- t(Ts0) %*% beta / (sigma*sqrt(t)*ST0)

ytrue<-approx(x1,y1, xout=xmse)$y

x_f0<-(ST0-S0)/S0
y_sievebound<-RND_ST0*S0
yest_sievebound<-approx(x_f0,y_sievebound, xout=xmse)$y

c1 <- c( xmse[2]-xmse[1]   , xmse[2:length(xmse)] - xmse[1: (length(xmse)-1)])

pos<-!is.na(yest_sievebound)
yest_sievebound_<-yest_sievebound[pos]
ytrue_<-ytrue[pos]
c1_<-c1[pos]

ISE_sievebound_<- sum( c1_*  (yest_sievebound_-ytrue_)^2  )

print(ISE_sievebound_)

################################################################

# remove the European variables to avoid conflicts

sigma<-0
AO_C0<-AO_C
AO_P0<-AO_P

##################################################################################################
#######################   Recover SPD based on the American option price  ######################################
###############################################################################################
comb <- function(x, ...) {
  lapply(seq_along(x),
         function(i) c(x[[i]], lapply(list(...), function(y) y[[i]])))
}


sim<-foreach (nsim_i= 1:nsim,
              .combine='comb', .multicombine=TRUE,.init=list(list(), list(),list(), list(),list(), list(),list(), list(), list(), list()),
              .errorhandling="remove",
              .packages=c("ragtop","orthopolynom","quadprog","nleqslv","parallel","doSNOW"),
              .options.snow=opts
) %dopar% {
  #print(nsim_i)
  source(file = file.path(dirname(getwd()), "functions", "kfold.R"))            #for cross validation
  source(file = file.path(dirname(getwd()), "functions", "CVJ.R"))              #cross validation to choose truncation order
  source(file = file.path(dirname(getwd()), "functions",  "RND.r"))             #calculate the RND based on the European option price
  source(file = file.path(dirname(getwd()), "functions",  "eep_hst.r"))         #compute the early exercise premium (eep) for a given exercise boundary and transition density  
  source(file = file.path(dirname(getwd()), "functions", "hst_eo_app.r"))       #compute the European option price
  source(file = file.path(dirname(getwd()), "functions", "EEPC.R")) 
  source(file = file.path(dirname(getwd()), "functions", "GBM_EO_AO.r")) 
  source(file = file.path(dirname(getwd()), "functions", "comparison_mse_functions.r")) 
  source(file = file.path(dirname(getwd()), "functions", "sievebound.R")) 
  set.seed(1+nsim_i*30000)
  
  #
  # # allow the price to be polluted by observation error
  err1 <- apply(cbind(-bd*rep(1,length(AO_C0)),AO_C0*runif(length(AO_C0), -ObsErr, ObsErr),bd*rep(1,length(AO_C0))),1,median)
  err2 <- apply(cbind(-bd*rep(1,length(AO_P0)),AO_P0*runif(length(AO_P0), -ObsErr, ObsErr),bd*rep(1,length(AO_P0))),1,median)
  
  #
  AO_C <- AO_C0+err1
  AO_P <- AO_P0+err2
  #
  
  call_AO<-cbind(rep(20000101,length(K0)),rep(t*365,length(K0)),rep(1,length(K0)),K0,EO_C,rep(S0,length(K0)),AO_C,rep(r/365,length(K0)),rep(sigma,length(K0)),EEP_C,rep(67.8,length(K0)))
  put_AO<-cbind(rep(20000101,length(K0)),rep(t*365,length(K0)),rep(0,length(K0)),K0,EO_P,rep(S0,length(K0)),AO_P,rep(r/365,length(K0)),rep(sigma,length(K0)),EEP_P,rep(67.8,length(K0)))
  OptionTau_AO<-data.frame(rbind(call_AO,put_AO))
  colnames(OptionTau_AO)<-c("Date","T","Type","K","EO","S","AO","Rf","Vol","EEP","X")
  #
  #
  date<-20000101
  #
  pos <- which( min(abs(OptionTau_AO$K - OptionTau_AO$S)) == abs(OptionTau_AO$K - OptionTau_AO$S))
  # # find at the money options
  obs<- OptionTau_AO[pos,][1,] #use the call; call also use both call and put
  # ImpVolc <- AmericanOptionImpliedVolatility("call", value=obs$AO, underlying=obs$S,
  #                                             strike=obs$K, dividendYield=delta, riskFreeRate=obs$Rf*365, maturity=obs$T/365, volatility=0.2*sqrt(365))[1]
  
  ImpVolc <-american_implied_volatility(obs$AO,1,obs$S,obs$K,obs$T/365,const_short_rate=obs$Rf*365-delta)
  # #print (ImpVolc)
  sigma<-ImpVolc
  #
  # #sigma<-0.368
  OptionTau_AO$Vol<-sigma
  #
  # ####################################  Initial estimate  ########################################
  #
  OptionTau<-data.frame(cbind(OptionTau_AO$Date,OptionTau_AO$T,OptionTau_AO$Type,OptionTau_AO$K,OptionTau_AO$AO,OptionTau_AO$S,OptionTau_AO$X,OptionTau_AO$Rf,OptionTau_AO$Vol))
  colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")
  rnd<-RND(OptionTau,date)
  x<-rnd[[1]]
  beta<-rnd[[2]]
  Ts<-rnd[[3]]
  Sigma<-rnd[[4]]
  ST  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))
  RND_ST <- t(Ts) %*% beta / (sigma*sqrt(t)*ST)
  
  
  #
  RR <- (ST-S0)/S0
  RND_R <- RND_ST*S0
  
  
  
  ########################################  First iteration   ####################################
  
  
  
  EE<-EEPC(K0,M,x,beta,Ts,sigma,r,delta,Delta,EEP_C,EEP_P)
  # #print (EE)
  #
  EEP1P<-EE[[1]]
  EEP1C<-EE[[2]]
  
  
  
  
  for (i in 1:length(K0)){
    OptionTau_AO$EEP1[i]<-EEP1C[i]
    OptionTau_AO$EEP1[length(K0)+i]<-EEP1P[i]
  }
  OptionTau_AO$EO1<-OptionTau_AO$AO-OptionTau_AO$EEP1
  #
  #
  #
  OptionTau<-data.frame(cbind(OptionTau_AO$Date,OptionTau_AO$T,OptionTau_AO$Type,OptionTau_AO$K,OptionTau_AO$EO1,OptionTau_AO$S,OptionTau_AO$X,OptionTau_AO$Rf,OptionTau_AO$Vol))
  colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")
  rnd1<-RND(OptionTau,date)
  x<-rnd1[[1]]
  beta<-rnd1[[2]]
  Ts<-rnd1[[3]]
  ST1  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))
  RND_ST1 <- t(Ts) %*% beta / (sigma*sqrt(t)*ST1)
  #
  
  #
  RR1 <- (ST1-S0)/S0
  RND_R1 <- RND_ST1*S0
  
  
  #
  # #print ('third round ');
  # ###########################################   Second iteration  #####################################
  EE<-EEPC(K0,M,x,beta,Ts,sigma,r,delta,Delta,EEP_C,EEP_P)
  # #print (EE)
  #
  EEP2P<-EE[[1]]
  EEP2C<-EE[[2]]
  #
  #
  for (i in 1:length(K0)){
    OptionTau_AO$EEP2[i]<-EEP2C[i]
    OptionTau_AO$EEP2[length(K0)+i]<-EEP2P[i]
  }
  OptionTau_AO$EO2<-OptionTau_AO$AO-OptionTau_AO$EEP2
  
  #
  #
  OptionTau<-data.frame(cbind(OptionTau_AO$Date,OptionTau_AO$T,OptionTau_AO$Type,OptionTau_AO$K,OptionTau_AO$EO2,OptionTau_AO$S,OptionTau_AO$X,OptionTau_AO$Rf,OptionTau_AO$Vol))
  colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")
  rnd2<-RND(OptionTau,date)
  x<-rnd2[[1]]
  beta<-rnd2[[2]]
  Ts<-rnd2[[3]]
  ST2  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))
  RND_ST2 <- t(Ts) %*% beta / (sigma*sqrt(t)*ST2)
  #
  
  #
  #
  RR2 <- (ST2-S0)/S0
  RND_R2 <- RND_ST2*S0
  #
  
  #
  # ##################################################   Third iteration   ######################################
  # #print ('fourth round ')
  EE<-EEPC(K0,M,x,beta,Ts,sigma,r,delta,Delta,EEP_C,EEP_P)
  # #print (EE)
  #
  EEP3P<-EE[[1]]
  EEP3C<-EE[[2]]
  #
  #
  for (i in 1:length(K0)){
    OptionTau_AO$EEP3[i]<-EEP3C[i]
    OptionTau_AO$EEP3[length(K0)+i]<-EEP3P[i]
  }
  OptionTau_AO$EO3<-OptionTau_AO$AO-OptionTau_AO$EEP3
  
  
  
  OptionTau<-data.frame(cbind(OptionTau_AO$Date,OptionTau_AO$T,OptionTau_AO$Type,OptionTau_AO$K,OptionTau_AO$EO3,OptionTau_AO$S,OptionTau_AO$X,OptionTau_AO$Rf,OptionTau_AO$Vol))
  colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")
  rnd3<-RND(OptionTau,date)
  x<-rnd3[[1]]
  beta<-rnd3[[2]]
  Ts<-rnd3[[3]]
  ST3  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))
  RND_ST3 <- t(Ts) %*% beta / (sigma*sqrt(t)*ST3)
  #
  
  #
  #
  RR3 <- (ST3-S0)/S0
  RND_R3 <- RND_ST3*S0
  #
  
  #
  #
  # ##################################################   Fourth iteration   ######################################
  # print ('fifth round ')
  EE<-EEPC(K0,M,x,beta,Ts,sigma,r,delta,Delta,EEP_C,EEP_P)
  # #print (EE)
  #
  EEP4P<-EE[[1]]
  EEP4C<-EE[[2]]
  
  
  for (i in 1:length(K0)){
    OptionTau_AO$EEP4[i]<-EEP4C[i]
    OptionTau_AO$EEP4[length(K0)+i]<-EEP4P[i]
  }
  OptionTau_AO$EO4<-OptionTau_AO$AO-OptionTau_AO$EEP4
  #
  #
  #
  OptionTau<-data.frame(cbind(OptionTau_AO$Date,OptionTau_AO$T,OptionTau_AO$Type,OptionTau_AO$K,OptionTau_AO$EO4,OptionTau_AO$S,OptionTau_AO$X,OptionTau_AO$Rf,OptionTau_AO$Vol))
  colnames(OptionTau)<-c("Date","T","Type","K","EO","S","X","Rf","Vol")
  rnd4<-RND(OptionTau,date)
  x<-rnd4[[1]]
  beta<-rnd4[[2]]
  Ts<-rnd4[[3]]
  ST4  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))
  RND_ST4 <- t(Ts) %*% beta / (sigma*sqrt(t)*ST4)
  #
  
  #
  #
  RR4 <- (ST4-S0)/S0
  RND_R4 <- RND_ST4*S0
  #
  
  
  ###########################################  MMT ######################################################
  v1<-c(rep(0,length(beta0)),1,0)
  v2<-c(rep(0,length(beta0)),0,1)
  v3<-c(rep(0,length(beta0)),-1,0)
  v4<-c(rep(0,length(beta0)),0,-1)
  
  opt<-constrOptim(c(beta0,1/2,1/2),sievebound_mse,NULL,ui=rbind(t(rbind(Ts0,rep(0,m),rep(0,m))),v1,v2,v3,v4),ci=c(rep(negtol,m),0,0,-1,-1))
  
  
  price<-sievebound_price(opt$par)
  beta<-opt$par[1:(degree+1)]
  x <- seq( minR, maxR, length.out=m)
  ST0  <- exp(x*sigma*sqrt(t) + (r)*t + log(S0))
  RND_ST0 <- t(Ts0) %*% beta / (sigma*sqrt(t)*ST0)
  
  ytrue<-approx(x1,y1, xout=xmse)$y
  
  x_f0<-(ST0-S0)/S0
  y_sievebound<-RND_ST0*S0
  yest_sievebound<-approx(x_f0,y_sievebound, xout=xmse)$y
  
  c1 <- c( xmse[2]-xmse[1]   , xmse[2:length(xmse)] - xmse[1: (length(xmse)-1)])
  
  pos<-!is.na(yest_sievebound)
  yest_sievebound_<-yest_sievebound[pos]
  ytrue_<-ytrue[pos]
  c1_<-c1[pos]
  
  xmse_<-xmse[pos]
  
  ISE_sievebound<- sum( c1_*  (yest_sievebound_-ytrue_)^2  )
  bias_sievebound<- sqrt(c1_)*(yest_sievebound_-ytrue_) 
  
  
  
  #####################################################################################################
  
  
  #######################################################   Tian (2011)   ###################################
  call_AO_Tian<-call_AO
  put_AO_Tian<-put_AO
  bin_N<-1000
  
  # if (min(RR4)>min(xmse)){
  #   xmse<-seq(min(RR4),max(x1),by=0.01)
  # }
  
  f_0_rr<-xmse
  f_0<-xmse*S0+S0
  # 
  # ###############################################################################
  # 
  # 
  sigma_opt1<-optimize(price_error_tian,c(0.1,0.5))$minimum
  # 
  
  # 
  # 
  call_EO1<-numeric(nrow(call_AO_Tian))
  put_EO1<-numeric(nrow(put_AO_Tian))
  call_AO1<-numeric(nrow(call_AO_Tian))
  put_AO1<-numeric(nrow(put_AO_Tian))
  call_EEP1<-numeric(nrow(call_AO_Tian))
  put_EEP1<-numeric(nrow(put_AO_Tian))
  
  for(i in 1:nrow(call_AO_Tian)){
    call_EO1[i]<-BlackScholes(call_AO_Tian[i,6],call_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,call_AO_Tian[i,2]/365,sigma_opt1,"C")
    call_AO1[i]<-american_call_bin(call_AO_Tian[i,6],call_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,sigma_opt1,call_AO_Tian[i,2]/365,bin_N)
    call_EEP1[i]<-call_AO1[i]-call_EO1[i]
    call_AO_Tian[i,7]<-call_AO[i,7]-call_EEP1[i]
  }
  for(i in 1:nrow(put_AO_Tian)){
    put_EO1[i]<-BlackScholes(put_AO_Tian[i,6],put_AO_Tian[i,4],put_AO_Tian[i,8]*365,delta,put_AO_Tian[i,2]/365,sigma_opt1,"P")
    put_AO1[i]<-american_put_bin(put_AO_Tian[i,6],put_AO_Tian[i,4],put_AO_Tian[i,8]*365,delta,sigma_opt1,put_AO_Tian[i,2]/365,bin_N)
    put_EEP1[i]<-put_AO1[i]-put_EO1[i]
    put_AO_Tian[i,7]<-put_AO[i,7]-put_EEP1[i]
  }
  
  sigma_opt2<-optimize(price_error_tian,c(0.1,0.5))$minimum
  
  # 
  # 
  # 
  # 
  call_EO2<-numeric(nrow(call_AO_Tian))
  put_EO2<-numeric(nrow(put_AO_Tian))
  call_AO2<-numeric(nrow(call_AO_Tian))
  put_AO2<-numeric(nrow(put_AO_Tian))
  call_EEP2<-numeric(nrow(call_AO_Tian))
  put_EEP2<-numeric(nrow(put_AO_Tian))
  # 
  for(i in 1:nrow(call_AO_Tian)){
    call_EO2[i]<-BlackScholes(call_AO_Tian[i,6],call_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,call_AO_Tian[i,2]/365,sigma_opt2,"C")
    call_AO2[i]<-american_call_bin(call_AO_Tian[i,6],call_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,sigma_opt2,call_AO_Tian[i,2]/365,bin_N)
    call_EEP2[i]<-call_AO2[i]-call_EO2[i]
    call_AO_Tian[i,7]<-call_AO[i,7]-call_EEP2[i]
  }
  for(i in 1:nrow(put_AO_Tian)){
    put_EO2[i]<-BlackScholes(put_AO_Tian[i,6],put_AO_Tian[i,4],put_AO_Tian[i,8]*365,delta,put_AO_Tian[i,2]/365,sigma_opt2,"P")
    put_AO2[i]<-american_put_bin(put_AO_Tian[i,6],put_AO_Tian[i,4],put_AO_Tian[i,8]*365,delta,sigma_opt2,put_AO_Tian[i,2]/365,bin_N)
    put_EEP2[i]<-put_AO2[i]-put_EO2[i]
    put_AO_Tian[i,7]<-put_AO[i,7]-put_EEP2[i]
  }
  # 
  sigma_opt3<-optimize(price_error_tian,c(0.1,0.5))$minimum
  # # 
  
  # # 
  # # 
  # # 
  call_EO3<-numeric(nrow(call_AO_Tian))
  put_EO3<-numeric(nrow(put_AO_Tian))
  call_AO3<-numeric(nrow(call_AO_Tian))
  put_AO3<-numeric(nrow(put_AO_Tian))
  call_EEP3<-numeric(nrow(call_AO_Tian))
  put_EEP3<-numeric(nrow(put_AO_Tian))
  # 
  for(i in 1:nrow(call_AO_Tian)){
    call_EO3[i]<-BlackScholes(call_AO_Tian[i,6],call_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,call_AO_Tian[i,2]/365,sigma_opt3,"C")
    call_AO3[i]<-american_call_bin(call_AO_Tian[i,6],call_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,sigma_opt3,call_AO_Tian[i,2]/365,bin_N)
    call_EEP3[i]<-call_AO3[i]-call_EO3[i]
    call_AO_Tian[i,7]<-call_AO[i,7]-call_EEP3[i]
  }
  for(i in 1:nrow(put_AO_Tian)){
    put_EO3[i]<-BlackScholes(put_AO_Tian[i,6],put_AO_Tian[i,4],put_AO_Tian[i,8]*365,delta,put_AO_Tian[i,2]/365,sigma_opt3,"P")
    put_AO3[i]<-american_put_bin(put_AO_Tian[i,6],put_AO_Tian[i,4],put_AO_Tian[i,8]*365,delta,sigma_opt3,put_AO_Tian[i,2]/365,bin_N)
    put_EEP3[i]<-put_AO3[i]-put_EO3[i]
    put_AO_Tian[i,7]<-put_AO[i,7]-put_EEP3[i]
  }
  # 
  sigma_opt4<-optimize(price_error_tian,c(0.1,0.5))$minimum
  # 
  
  # 
  
  call_EO4<-numeric(nrow(call_AO_Tian))
  put_EO4<-numeric(nrow(put_AO_Tian))
  call_AO4<-numeric(nrow(call_AO_Tian))
  put_AO4<-numeric(nrow(put_AO_Tian))
  call_EEP4<-numeric(nrow(call_AO_Tian))
  put_EEP4<-numeric(nrow(put_AO_Tian))
  # 
  for(i in 1:nrow(call_AO_Tian)){
    call_EO4[i]<-BlackScholes(call_AO_Tian[i,6],call_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,call_AO_Tian[i,2]/365,sigma_opt4,"C")
    call_AO4[i]<-american_call_bin(call_AO_Tian[i,6],call_AO_Tian[i,4],call_AO_Tian[i,8]*365,delta,sigma_opt4,call_AO_Tian[i,2]/365,bin_N)
    call_EEP4[i]<-call_AO4[i]-call_EO4[i]
    call_AO_Tian[i,7]<-call_AO[i,7]-call_EEP4[i]
  }
  for(i in 1:nrow(put_AO_Tian)){
    put_EO4[i]<-BlackScholes(put_AO_Tian[i,6],put_AO_Tian[i,4],put_AO_Tian[i,8]*365,delta,put_AO_Tian[i,2]/365,sigma_opt4,"P")
    put_AO4[i]<-american_put_bin(put_AO_Tian[i,6],put_AO_Tian[i,4],put_AO_Tian[i,8]*365,delta,sigma_opt4,put_AO_Tian[i,2]/365,bin_N)
    put_EEP4[i]<-put_AO4[i]-put_EO4[i]
    put_AO_Tian[i,7]<-put_AO[i,7]-put_EEP4[i]
  }
  # 
  sigma_opt5<-optimize(price_error_tian,c(0.1,0.5))$minimum
  g_tian<-dlnorm(f_0,log(S0)+(r-delta)*t,sigma_opt5)
  g_tian_rr<-g_tian*S0
  # # plot(f_0_rr,g_tian_rr,type='l')
  ############################################## Melick and and Thomas (1997)   ######################
  call_AO_Melick<-call_AO
  put_AO_Melick<-put_AO
  
  
  opt<-optim(c(0.3,0.7,log(S0-2),log(S0),log(S0+2),0.2,0.2,0.2,1/3,1/3),price_error_Melick)
  
  
  
  mu1_<-opt$par[3]
  mu2_<-opt$par[4]
  mu3_<-opt$par[5]
  sigma1_<-opt$par[6]
  sigma2_<-opt$par[7]
  sigma3_<-opt$par[8]
  pi1_<-opt$par[9]
  pi2_<-opt$par[10]
  pi3_<-1-pi1_-pi2_
  
  g_Melick<-pi1_*dlnorm(f_0,mu1_,sigma1_)+pi2_*dlnorm(f_0,mu2_,sigma2_)+pi3_*dlnorm(f_0,mu3_,sigma3_)
  
  g_Melick_rr<-g_Melick*S0
  # plot(f_0_rr,g_Melick_rr,type='l')
  ##########################################################################
  
  
  xsieve<-RR4
  ysieve<-RND_R4[,1]
  
  x_f0<-f_0_rr
  y_tian<-g_tian_rr
  y_Melick<-g_Melick_rr
  # 
  # #xmse<-seq(-0.6,0.8,by=0.01)
  # 
  # #plot(x=RR4,y=RND_R4[,1], type="l", lty=2, lwd=2,xlab="x", ylab="",col="black", xlim=c(-0.8,0.8),ylim=c(0,3.5) )
  yest<-approx(xsieve,ysieve, xout=xmse, ties = min)$y
  yest_tian<-approx(x_f0,y_tian, xout=xmse, ties = min)$y
  yest_Melick<-approx(x_f0,y_Melick, xout=xmse, ties = min)$y
  ytrue<-approx(x1,y1, xout=xmse, ties = min)$y
  xtrue<-xmse
  
  
  
  c1 <- c( xmse[2]-xmse[1]   , xmse[2:length(xmse)] - xmse[1: (length(xmse)-1)])
  
  ISE_tian <- sum( c1*  (yest_tian-ytrue)^2  )
  ISE_Melick <- sum( c1*  (yest_Melick-ytrue)^2  )
  
  
  bias_Melick<- sqrt(c1)*(yest_Melick-ytrue)
  bias_tian<- sqrt(c1)*(yest_tian-ytrue)
  
  pos<-!is.na(yest)
  yest_<-yest[pos]
  ytrue_<-ytrue[pos]
  c1_<-c1[pos]
  xsieve_<-xmse[pos]
  
  ISE_sieve <- sum( c1_*  (yest_-ytrue_)^2  )
  bias_sieve<- sqrt(c1_)*(yest_-ytrue_)
  
  # ISE_sievebound <- sum( c1*  (yest_sievebound-ytrue)^2  ) #added
  # bias_sievebound<- sqrt(c1)*(yest_sievebound-ytrue)   #added
  
  #list(ISE_sievebound,ISE_sieve,ISE_tian,ISE_Melick,sqrt(ISE_sievebound),sqrt(ISE_sieve), sqrt(ISE_tian),sqrt(ISE_Melick),yest,yest_sievebound_,yest_tian,yest_Melick,xtrue,ytrue)
  list(bias_sieve,bias_tian, bias_Melick,bias_sievebound,ISE_sieve,ISE_tian,ISE_Melick, ISE_sievebound,xsieve_,xmse_)
  
  
  
}

parallel::stopCluster(cl = my.cluster)

ISE_sieve<-0
bias2_sieve<-0

ISE_Melick<-0
bias2_Melick<-0

ISE_tian<-0
bias2_tian<-0

ISE_sievebound<-0
bias2_sievebound<-0

min_sieve<--1
max_sieve<-1

for (i in 1:nsim) {
  
  if (min_sieve<min(sim[[9]][[i]])){
    min_sieve<-min(sim[[9]][[i]])
  }
  
  if (max_sieve>max(sim[[9]][[i]])){
    max_sieve<-max(sim[[9]][[i]])
  }
  
}


min_sievebound<--1
max_sievebound<-1

for (i in 1:nsim) {
  
  if (min_sievebound<min(sim[[10]][[i]])){
    min_sievebound<-min(sim[[10]][[i]])
  }
  
  if (max_sievebound>max(sim[[10]][[i]])){
    max_sievebound<-max(sim[[10]][[i]])
  }
  
}

## Post data processing
for (i in 1:nsim){
  b_sieve<-unlist(sim[[1]][i])
  b_tian<-unlist(sim[[2]][i])
  b_Melick<-unlist(sim[[3]][i])
  b_sievebound<-unlist(sim[[4]][i])
  x_sieve<-unlist(sim[[9]][i])
  x_sievebound<-unlist(sim[[10]][i])
  
  I_sieve<-unlist(sim[[5]][i])
  I_tian<-unlist(sim[[6]][i])
  I_Melick<-unlist(sim[[7]][i]) 
  I_sievebound<-unlist(sim[[8]][i])
  
  #print (length(b_sieve))
  
  b_sieve_<-approx(x_sieve,b_sieve,xout=seq(min_sieve,max_sieve,by=0.01))$y
  
  ISE_sieve <- ISE_sieve+I_sieve
  
  bias2_sieve<- bias2_sieve+b_sieve_
  
  ISE_Melick <- ISE_Melick+I_Melick
  
  bias2_Melick<- bias2_Melick+b_Melick
  
  ISE_tian <- ISE_tian+I_tian
  
  bias2_tian<- bias2_tian+b_tian
  
  ISE_sievebound <- ISE_sievebound+I_sievebound
  
  b_sievebound_<-approx(x_sievebound,b_sievebound,xout=seq(min_sievebound,max_sievebound,by=0.01))$y
  
  bias2_sievebound<- bias2_sievebound+b_sievebound_
  
  
  
  
}

ISE_sieve<-ISE_sieve/nsim
bias2_sieve<-bias2_sieve/nsim
bias2_sieve<- sum( abs(bias2_sieve)^2 )

ISE_Melick<-ISE_Melick/nsim
bias2_Melick<-bias2_Melick/nsim
bias2_Melick<- sum( abs(bias2_Melick)^2 )

ISE_tian<-ISE_tian/nsim
bias2_tian<-bias2_tian/nsim
bias2_tian<- sum( abs(bias2_tian)^2 )

ISE_sievebound<-ISE_sievebound/nsim
bias2_sievebound<-bias2_sievebound/nsim
bias2_sievebound<- sum( abs(bias2_sievebound)^2 )

print ("squared biases: sieve, tian, Melick, MMT")

print (c(bias2_sieve,bias2_tian,bias2_Melick, bias2_sievebound))

print ("ISE: sieve, tian, Melick, MMT")

print (c(ISE_sieve,ISE_tian,ISE_Melick,ISE_sievebound))




save(sim,file="tfsv_mise_5000_bd=10.RData")